﻿using System;
using OaktreeLab.ezSpectra;

namespace ezSpectraAPI_Sample {
    class Program {
        static void Main( string[] args ) {
            Console.Title = "ezSpectra API Sample";

            // ezSpectraAPIのインスタンスを作成する
            ezSpectraAPI ezs = new ezSpectraAPI();

            // ホストアプリに接続する
            Console.Write( "Connect: " );
            ezs.Connect();
            Console.WriteLine( "OK" );

            // ダーク補正を実行する
            //Console.Write( "Execute dark-current sampling: " );
            //ezs.ExecuteDarkCurrentSampling();
            //Console.WriteLine( "Done" );

            // サンプリング品質：高
            Console.Write( "Set sampling quality to High: " );
            ezs.SamplingQuality = SamplingQualityType.High;
            Console.WriteLine( "OK" );

            // 露光時間設定
            //Console.Write( "Set exposure time to 300ms: " );
            //ezs.SetExposureTime( 300 );
            //Console.WriteLine( "OK" );

            // 自動露光ON
            Console.Write( "Set auto exposure ON: " );
            ezs.AutoExposure = true;
            Console.WriteLine( "OK" );

            // サンプリングを実行する
            Console.Write( "Execute sampling: " );
            ezs.ExecuteSampling();
            Console.WriteLine( "Done" );

            // サンプリング結果を取得する
            Console.Write( "Retrieve current spectrum: " );
            Spectrum s = ezs.CurrentSpectrum;
            Console.WriteLine( "OK" );
            // 試にピーク波長を表示してみる
            Console.WriteLine( "Peek wavelength: {0:f1}nm", s.Peek.WaveLength );

            // スペクトル解析結果を取得する
            Console.Write( "Retrieve analysis result: " );
            AnalysisResult ar = ezs.CurrentAnalysisResult;
            Console.WriteLine( "OK" );
            // 色温度
            Console.WriteLine( "  CCT: {0}", ar.CCT );
            // 平均演色評価数
            Console.WriteLine( "  Ra: {0}", ar.Ra );

            // ホストアプリをリセットする
            Console.Write( "Reset: " );
            ezs.Reset();
            Console.WriteLine( "OK" );

            Console.WriteLine( "Done." );
            WaitKey();
        }

        private static void WaitKey() {
            Console.WriteLine( "Hit return key." );
            Console.ReadLine();
        }
    }
}
